/*
 * String and string array manipulation routines
 */

#include <stdio.h>

#include "libfma.h"
#include "lf_internal.h"

/*
 * utility to manage string arrays
 */
void
lf_free_string_array(
  char **strings,
  int nstr)
{
  int i;

  if (strings != NULL) {
    for (i=0; i<nstr; ++i) {
      LF_FREE(strings[i]);
    }
    LF_FREE(strings);
  }
}

char **
lf_dup_string_array(
  char **strings,
  int nstr)
{
  char **sp;
  int i;

  sp = (char **) calloc(nstr, sizeof(char *));
  if (sp == NULL) return NULL;

  for (i=0; i<nstr; ++i) {
    LF_DUP_STRING(sp[i], strings[i]);
  }

  return sp;

 except:
  lf_free_string_array(sp, nstr);
  return NULL;
}

